'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' ACD CHEMBASIC DEMO PROGRAM                                          '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'                                                                     '
' Molecular 3D Editor//MIRROR.BAS                                     '
'                                                                     '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'                                                                     '
' The utility flips the molecule at a plane                           '
'                                                                     '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


CONST TITLE="ChemBasic Molecular Editor // Mirror"


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Function Main As String
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' MIRROR.BAS                                                          '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim page,diag,asm,struc As Object, s As String, OK As Boolean

  MAIN="Failed or nothing to do!"

  ' Get 1st structure from the curent page
  page=ActiveDocument.ActivePage
  If page.Diagrams.Count<1 Then Exit Function
  diag=page.Diagrams.Item(1)
  asm=Assemblies.AddFromCS(diag)
  If asm=NULL Then Exit Function
  struc=Asm.Structures.Item(1)
  If struc=NULL Then Exit Function

  ' Do the job
  s=UserIOBox("Flip X, Y, or Z coordinate ?" ,TITLE ,  "Y")
  s=UCase(Left(s,1))
  If s="X" OR s="Y" OR s="Z" Then
    ' Flip !
    Call Flip(struc,s)
    ' Show the results
    RefreshDiagram(diag,struc)
    Main="Completed."
  End If

End Function



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub Flip(struc As Object,s As String)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim x,y,z As Double, asm,at As Object
  With struc
    asm=.Assembly
    For Each at In asm
      .GetAtomXYZ(at,x,y,z)
      Select Case s
        Case "X"
          x=-x
        Case "Y"
          y=-y
        Case "Z"
          z=-z
      End Select
      .SetAtomXYZ(at,x,y,z)
    Next at
  End With
End Sub


'***LIBRARY PROCEDURES BEGIN



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub RefreshDiagram(diag As Object,strmol As Object)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' LIB0.BAS PROCEDURE                                                  '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Redraws the diagram with a molecule or structure object             '
'                                                                     '
' ENTER                                                               '
'     diag            object of type CS_DIAGRAM                       '
'     strmol          object of type CB_MOLECULE or CB_STRUCTURE      '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim l,t,w,h,w1,h1 As Integer
  diag.GetBound(l,t,w,h)
  diag.Depict(strmol)
  diag.GetBound(w,h,w1,h1)
  diag.SetBound(l,t,w1,h1)
End Sub



'***LIBRARY PROCEDURES END

'@@@@@@